/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.nooj4nlp.controller.DictionaryPropDefDialog.CancelActionListener;
import net.nooj4nlp.engine.Engine;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.gui.actions.shells.construct.NewDictionaryActionListener;
import net.nooj4nlp.gui.actions.shells.construct.NewPropDefActionListener;
import net.nooj4nlp.gui.main.Launcher;

public class DictionaryPropDefDialog
extends JDialog {
    private static final long serialVersionUID = 3762020754004251438L;
    private final JPanel contentPanel = new JPanel();
    private Language myLan;
    private Engine myEngine;

    public DictionaryPropDefDialog(boolean dictionary) {
        if (dictionary) {
            this.setTitle("Import and INTEX-type dictionary");
        } else {
            this.setTitle("File");
        }
        this.setBounds(100, 100, 229, 297);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(null);
        JPanel pnlLang = new JPanel();
        pnlLang.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "(1) Select:", 4, 2, null, new Color(0, 0, 0)));
        pnlLang.setBounds(10, 11, 119, 240);
        this.contentPanel.add(pnlLang);
        pnlLang.setLayout(null);
        JList<String> listLanguages = new JList<String>(Language.getAllLanguages());
        listLanguages.setSelectedValue(Launcher.preferences.deflanguage, true);
        JScrollPane scrollPane = new JScrollPane(listLanguages, 22, 31);
        scrollPane.setBorder(new BevelBorder(1, null, null, null, null));
        scrollPane.setBounds(10, 24, 99, 205);
        pnlLang.add(scrollPane);
        JButton okButton = new JButton("OK");
        if (dictionary) {
            okButton.addActionListener(new NewDictionaryActionListener(listLanguages, this));
        } else {
            okButton.addActionListener(new NewPropDefActionListener(listLanguages, this));
        }
        okButton.setBounds(139, 228, 70, 25);
        this.contentPanel.add(okButton);
        okButton.setActionCommand("OK");
        this.getRootPane().setDefaultButton(okButton);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setActionCommand("OK");
        btnCancel.setBounds(139, 194, 70, 25);
        btnCancel.addActionListener(new CancelActionListener(this));
        this.contentPanel.add(btnCancel);
    }
}

